"use strict";class Validator{constructor(element,options){if(typeof validate==="undefined")throw new Error("Validate.js is required by Validator to run properly");if(!isElement(element)||element.nodeName!=="FORM")throw new Error("Validator can only work on form element");this.form=element;this.constraints={};this.ignore=['[type="hidden"]',".hidden",".ignore"];this.event="submit";this.eventHandler=(form,e)=>{};this.error=error=>console.log(error);if(typeof options==="object")this.set(options);this.parse();this.form.validator=this}set(options){let instance=this;for(let key in options){if(options.hasOwnProperty(key))instance[key]=options[key]}}addRule(field="",rules={}){let self=this;if(typeof field==="string"&&field!==""&&typeof rules==="object"){self.constraints[field]=rules}}removeRule(field="",rules={}){let self=this;if(rules==={}){delete self.constraints[field]}else{for(let key in rules){if(rules.hasOwnProperty(key)&&self.constraints[field].hasOwnProperty(key))delete self.constraints[field][key]}}}parse(){let self=this;forEach("input,select,textarea",(e=>{let valid=true,i=0;while(valid&&i<self.ignore.length){valid=!e.matches(self.ignore[i])&&e.hasAttribute("name")&&e.getAttribute("name")!=="";i++}if(valid){let required=e.hasAttribute("required")||e.classList.contains("required");let name=e.getAttribute("name");let min=e.getAttribute("min");let max=e.getAttribute("max");let size=e.getAttribute("size");let cs={};if(required)cs["presence"]=true;switch(e.nodeName){case"input":let type=e.getAttribute("type");let equalTo=e.hasAttribute("equalTo")?e.getAttribute("equalTo"):"";if(equalTo!=="")cs["equality"]=equalTo;switch(type){case"text":case"password":case"email":case"tel":if(min&&(max||size))cs["length"]={minimum:min,maximum:size?size:max};if(min)cs["length"]={minimum:min};if(max||size)cs["length"]={maximum:size?size:max};if(type==="email")cs["email"]=true;break;case"number":case"range":cs["numericality"]=true;if(min&&(max||size))cs["numericality"]={greaterThan:min,lessThanOrEqualTo:size?size:max};if(min)cs["numericality"]={greaterThan:min};if(max||size)cs["numericality"]={lessThanOrEqualTo:size?size:max};break}break;case"select":break;case"textarea":if(min&&(max||size))cs["length"]={minimum:min,maximum:size?size:max};if(min)cs["length"]={minimum:min};if(max||size)cs["length"]={maximum:size?size:max};break}if(!isEmpty(cs))self.constraints[name]=cs}}),self.form)}closestParent(child,className){let instance=this;if(!child||child===document){return null}if(child.classList.contains(className)){return child}else{return instance.closestParent(child.parentNode,className)}}showErrorsForInput(field,errors={}){let instance=this;field.classList.remove("invalid");field.removeAttribute("aria-describedby");let formGroup=instance.closestParent(field.parentNode,"form-group");if(formGroup===null)return;formGroup.classList.remove("has-error","has-feedback");let errorsBlock=formGroup.querySelector(".error");if(errorsBlock!==null)errorsBlock.remove();if(errors.length){if(field.nodeName==="input"&&field.type==="hidden")return;let id=field.name+"_error";formGroup.classList.add("has-error");field.setAttribute("aria-describedby",id);let errorBlock=document.createElement("span");errorBlock.classList.add("help-block","error");errorBlock.setAttribute("id",id);errorBlock.setAttribute("role","alert");errorBlock.setAttribute("aria-live","polite");errors.forEach((error=>{let errorSpan=document.createElement("span");errorSpan.textContent=error;errorBlock.appendChild(errorSpan)}));formGroup.appendChild(errorBlock)}}showErrors(form,errors){let instance=this;forEach("input[name], select[name], textarea[name]",(field=>{instance.showErrorsForInput(field,errors.hasOwnProperty(field.name)?errors[field.name]:{})}),form)}listen(options={}){let constraints=Object.assign({},this.constraints,options),instance=this;instance.form.addEventListener(instance.event,(event=>{event.preventDefault();let errors=validate(instance.form,constraints,{fullMessages:false});instance.showErrors(instance.form,errors||{});if(!errors)instance.eventHandler(instance.form,event);return false}))}}