/**
 * Définir les valeurs par defaut pour le comportement du callback
 * *
 $.jmRequest.defaults = {
    display: true,
    refresh: false,
    redirectUrl: null,
    timeout: 2800,
    debug: false
};

 /**
 * Définir les valeurs par defaut pour le mode de notification
 * *
 $.jmRequest.notifier = {
    cssClass : '.mc-message'
};

 $.jmRequest({
    handler: "ajax",
    url: '',
    method: 'GET',
    dataType: 'json'
});

 $("#my_form").on('submit',function(){
     $.jmRequest({
            handler: "submit",
            url: '',
            method: 'post',
            form: $(this),
            resetForm:true,
            beforeSend:function(){},
            success:function(e){
                $.jmRequest.initbox(e,{
                        display: true
                    },{
                        cssClass : '.mc-message'
                    }
                );
            }
	 });
	 return false;
});
 *
 */

;(function ( $, window, document, undefined ) {
    $.jmRequest = function(options){
        var settings = {
            handler: "ajax",
            method: "POST",
            dataType : '',
            url: null,
            data: {},/*data: { key1: 'value1', key2: 'value2' }*/
            form: null,
            /*
            * beforeSerialize: function($form, options) {
             // return false to cancel submit
             }
            * */
            beforeSerialize:null,
            resetForm: null,
            clearForm: null,/*Boolean flag indicating whether the form should be cleared if the submit is successful*/
            target: null,
            statusCode: {
                0: function() {
                    console.error("jQuery Error");
                },401: function() {
                    console.warn("access denied");
                },404: function() {
                    console.warn("object not found");
                },403: function() {
                    console.warn("request forbidden");
                },408: function() {
                    console.warn("server timed out waiting for request");
                },500: function() {
                    console.error("Internal Server Error");
                }
            },
            processData: true,
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            async: true,
            cache: false,
            dataFilter: false,//function (response) {},
            beforeSend: false,
            xhr: false,
            error: function (xhr, ajaxOptions, thrownError) {
                console.log(xhr);
                console.log(ajaxOptions);
                console.log(thrownError);
            },
            success: function(e, textStatus, XMLHttpRequest){
                $.jmRequest.initbox(e);
            },
            complete: false//function () {}
        };
        var opt = $.extend(true,{},settings,options);
        //console.log(opt.uri);
        //var self : this,
        if(typeof opt != 'object' || opt == "undefined"){
            console.log(opt);
        }
        if(opt.handler == "undefined" || opt.handler == '' || opt.handler == null){
            console.log('handler is null');
        }
        var initHandler = {
            jmAjax: function(){
                // --- Default options of the ajax request
                var ajaxParams = {
                    method: opt.method,
                    type: opt.method,
                    url: opt.url,
                    dataType: opt.dataType,
                    statusCode: opt.statusCode,
                    processData:opt.processData,
                    contentType:opt.contentType,
                    async: opt.async,
                    cache: opt.cache,
                    data: opt.data,
                    beforeSend: opt.beforeSend,
                    success: opt.success
                };
                if(opt.dataType){
                    ajaxParams.dataType = opt.dataType;
                }
                if(opt.async){
                    ajaxParams.async = opt.async;
                }
                /*if(opt.processData){
                    ajaxParams.processData = opt.processData;
                }
                if(opt.contentType){
                    ajaxParams.contentType = opt.contentType;
                }*/
                if(opt.dataFilter){
                    ajaxParams.dataFilter = opt.dataFilter;
                }
                if(opt.xhr){
                    ajaxParams.xhr = opt.xhr;
                }
                if(opt.error){
                    ajaxParams.error = opt.error;
                }
                if(opt.complete){
                    ajaxParams.complete = opt.complete;
                }
                if(opt.debug == true) {
                    if( console && console.log ) {
                        console.log(ajaxParams);
                    }
                }
                $.ajax(ajaxParams).done(function ( data ) {
                    if(opt.debug == true){
                        if( console && console.log ) {
                            console.log(data);
                        }
                    }
                }).fail(function(xhr, status, error){
                    console.group('Error jmRequest');
                    console.error('Status %s ',status);
                    console.error('URL: '+opt.url+' %s',error);
                    console.error('xhr %s ',xhr);
                    console.log(opt);
                    console.dir(ajaxParams);
                    console.groupEnd();
                });
            },
            jmSubmit: function(){
                if(jQuery().ajaxSubmit) {
                    if(opt.debug == true){
                        $(opt.form).ajaxSubmit.debug = true;
                    }else{
                        $(opt.form).ajaxSubmit.debug = false;
                    }
                    $(opt.form).ajaxSubmit({
                        url:opt.url,
                        type:opt.method,
                        data:opt.data,
                        dataType: opt.dataType,
                        resetForm: opt.resetForm,
                        clearForm: opt.clearForm,
                        forceSync:false,
                        beforeSerialize:opt.beforeSerialize,
                        beforeSubmit:opt.beforeSend,
                        success: opt.success
                    });
                }else{
                    console.error('jquery form is not defined');
                }
            },
            jmForm: function(){

                if(jQuery().ajaxForm) {
                    if(opt.debug == true){
                        $(opt.form).ajaxForm.debug = true;
                    }else{
                        $(opt.form).ajaxForm.debug = false;
                    }
                    $(opt.form).ajaxForm({
                        url:opt.url,
                        type:opt.method,
                        data:opt.data,
                        dataType: opt.dataType,
                        resetForm: opt.resetForm,
                        clearForm: opt.clearForm,
                        forceSync:false,
                        beforeSerialize:opt.beforeSerialize,
                        beforeSubmit:opt.beforeSend,
                        success: opt.success
                    });
                }else{
                    console.error('jquery form is not defined');
                }
            }
        }
        if(opt.handler == ""){
            console.log("%s: %o","handler is null");
            return false;
        }else if(typeof(opt.handler) === "undefined"){
            console.log("%s: %o","handler is undefined");
            return false;
        }else{
            switch(opt.handler){
                case "ajax":
                    initHandler.jmAjax();
                    break;
                case "submit":
                    initHandler.jmSubmit();
                    break;
                case "form":
                    initHandler.jmForm();
                    break;
            }
        }
    };
    /**
     * Paramètres par defaut pour le comportement du callback
     * @type {Object}
     */
    $.jmRequest.defaults = {
        display: true,
        refresh: false,
        redirectUrl: false,
        timeout: 2800,
        debug: false
    };

    /**
     * Paramètres par defaut pour le mode de notification
     * @type {Object}
     */
    $.jmRequest.notifier = {
        cssClass : '.mc-message'
    };

    /**
     * Redirection function.
     * @param {string} loc - url where to redirect.
     * @param {int} [timeout=2800] - Time before redirection.
     */
    function redirect(loc,timeout) {
        timeout = typeof timeout !== 'undefined' ? timeout : 2800;
        setTimeout(function(){
            window.location.href = loc;
        },timeout);
    }

    function reload(timeout){
        timeout = typeof timeout !== 'undefined' ? timeout : 2800;
        setTimeout(function(){
            location.reload();
        },timeout);
    }

    /**
     * Retourne le setting avec des conditions pour la notification
     * @param setting
     * @return {Object|String}
     * @private
     */
    function setBoxParams(setting){
        var optDefault = $.jmRequest.notifier;
        if(setting != null){
            if(typeof(setting.cssClass) === "undefined"){
                setClass = optDefault.cssClass;
            }else{
                setClass = setting.cssClass;
            }
        }else{
            if(typeof(optDefault.cssClass) === "undefined" || optDefault.cssClass === ""){
                setClass = "";
            }else{
                setClass = optDefault.cssClass;
            }
        }
        var config = {
            cssClass : setClass
        };
        if ( typeof config != 'object' ){
            console.log("%s: %o","config is not objet");
        }else{
            return config;
        }
    }

    /**
     * Définition du comportement de l'affichage du callback
     * @param response
     * @param setDefault
     * @param setNotifier
     */
    $.jmRequest.initbox = function(response,setDefault,setNotifier) {
        var opts = $.extend(true,{},$.jmRequest.defaults,setDefault);
        var optsNotifier = $.extend(true,{},$.jmRequest.notifier,setBoxParams(setNotifier));
        if ( !$.isPlainObject( opts ) ){
            console.log( optsNotifier.class );
        }
        if(typeof opts !== 'object'){
            console.log("%s: %o","jmRequest default initbox is not object");
        }else if(typeof optsNotifier != 'object'){
            console.log("%s: %o","jmRequest notifier initbox is not object");
        }
        if(opts.display !== false){

            if(optsNotifier.cssClass !== '' || optsNotifier.cssClass !==null){
                var classContainer = optsNotifier.cssClass;
            }else{
                var classContainer = '';
            }

            if(opts.debug == true){
                console.info(classContainer);
            }
            $(classContainer).html(response);
        }

        if(opts.redirectUrl != false || opts.redirectUrl != ""){
            redirect(opts.redirectUrl,opts.timeout);
        }

        if(opts.refresh == true){
            reload(opts.timeout);
        }
    }
})( jQuery, window, document );