<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Mage Pattern.
# The toolkit PHP for developer
# Copyright (C) 2012 - 2013 Gerits Aurelien contact[at]aurelien-gerits[dot]be
#
# OFFICIAL TEAM MAGE PATTERN:
#
#   * Gerits Aurelien (Author - Developer) contact[at]aurelien-gerits[dot]be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# DISCLAIMER

# Do not edit or add to this file if you wish to upgrade Mage Pattern to newer
# versions in the future. If you wish to customize Mage Pattern for your
# needs please refer to http://www.magepattern.com for more information.
#
# -- END LICENSE BLOCK -----------------------------------
/**
 * Created by SC BOX.
 * User: aureliengerits
 * Date: 22/07/12
 * Time: 16:36
 *
 */
class xml_sitemap extends xml_factory_sitemap{
    /**
     * @var XMLWriter
     */
    protected static $xmlWriter;

    /**
     * @throws Exception
     * @return XMLWriter
     */
    private function xmlWriter(){
        if (!isset(self::$xmlWriter)){
            if(is_null(self::$xmlWriter)){
                if(class_exists('XMLWriter')){
                    self::$xmlWriter = new XMLWriter();
                }else{
                    throw new Exception('class XMLWriter is not exist');
                }
            }
        }
        return self::$xmlWriter;
    }
    /**
     *
     * @var array() siteMapURL
     * @access private
     */
    private $siteMapURL = array();

    /**
     * Create XML File
     * @param $file (string)
     * @throws Exception
     * @internal param $fpath
     * @return void
     */
    public function createNewFile($file){
        if (!file_exists($file)) {
            //if(is_writable($file)){
                $handle = @fopen($file,'a+');
                if($handle){
                    if(@chmod($file,0755)){
                        return true;
                    }
                    fclose($handle);
                }
            /*}else{
                throw new Exception("Folder is not writable");
            }*/
        }
    }

    /**
     * Open File and Create new xmlwriter using source uri for output
     * @param $file (string)
     * @throws Exception
     * @internal param $fpath
     * @return void
     */
    public function openUri($file){
        if (file_exists($file)) {
            if (!is_writable($file)) {
                throw new Exception(sprintf('%s is not writable', $file));
            }else{
                $this->xmlWriter()->openUri($file);
            }
        }else{
            throw new Exception(sprintf('%s not file exist', $file));
        }
    }
    /**
     * Toggle indentation on/off
     * @param $indent = true/false
     * @return void
     */
    public function setIndent($indent=true){
        $this->xmlWriter()->setIndent($indent);
    }

    /**
     * End Parent element
     * @return void
     */
    public function endElement(){
        $this->xmlWriter()->endElement();
    }

    /**
     * End Parent element
     * @return void
     */
    public function endDocument(){
        $this->xmlWriter()->endDocument();
    }

    /**
     * Entête du fichier sitemap XML
     * @param array $setConfig
     */
    public function headerSitemap($setConfig = array('encode'=>'UTF-8','type'=>'child')){
        switch($setConfig['type']){
            case 'parent':
                $this->xmlWriter()->startDocument('1.0', $setConfig['encode']);
                $this->xmlWriter()->writeComment('Generated by Mage Pattern');
                $this->xmlWriter()->startElement ('sitemapindex'); // [1] First Node
                $this->xmlWriter()->writeAttribute('xmlns' , $this->NS);
                break;
            case 'child':
                $this->xmlWriter()->startDocument('1.0', $setConfig['encode']);
                $this->xmlWriter()->writeComment('Generated by Mage Pattern');
                $this->xmlWriter()->startElement ('urlset'); // [1] First Node
                $this->xmlWriter()->writeAttribute('xmlns' , $this->NS);
                break;
            case 'image':
                $this->xmlWriter()->startDocument('1.0', $setConfig['encode']);
                $this->xmlWriter()->writeComment('Generated by Mage Pattern');
                $this->xmlWriter()->startElement ('urlset'); // [1] First Node
                $this->xmlWriter()->writeAttribute('xmlns' , $this->NS);
                $this->xmlWriter()->writeAttribute('xmlns:image' , $this->googleimages_xmlns);
                break;
        }
    }

    /**
     * Ecriture des noeuds du sitemap XML
     * @param array $setConfig
     */
    public function writeNode($setConfig = array('type'=>'child','loc'=>'','image'=>false,'lastmod'=>'','changefreq'=>'always','priority'=>'0.7')){
        $dataFormat = new date_dateformat();
        if(is_array($setConfig)){
            switch($setConfig['type']){
                case 'parent':
                    $this->xmlWriter()->startElement('sitemap');// [2] Second Node
                    $this->xmlWriter()->writeElement('loc',form_inputFilter::isURL($setConfig['loc']));
                    $this->xmlWriter()->writeElement('lastmod',$dataFormat->dateW3C($setConfig['lastmod']));
                    $this->xmlWriter()->endElement();
                    break;
                case 'child':
                    $this->xmlWriter()->startElement('url');// [2] Second Node
                    $this->xmlWriter()->writeElement('loc',form_inputFilter::isURL($setConfig['loc']));
                    $this->xmlWriter()->writeElement('lastmod',$dataFormat->dateW3C($setConfig['lastmod']));
                    $this->xmlWriter()->writeElement('changefreq',$setConfig['changefreq']);
                    $this->xmlWriter()->writeElement('priority',$setConfig['priority']);
                    $this->xmlWriter()->endElement();
                    break;
                case 'image':
                    $this->xmlWriter()->startElement('url');// [2] Second Node
                    $this->xmlWriter()->writeElement('loc',form_inputFilter::isURL($setConfig['loc']));
                    if($setConfig['image'] != '' AND $setConfig['image'] != false AND is_array($setConfig['image'])){
                        if(is_array($setConfig['image'])){
                            if(isset($setConfig['image']['loop'])){
                                foreach($setConfig['image']['loop'] as $key){
                                    $this->xmlWriter()->startElement('image:image');// [2] Second Node
                                    $this->xmlWriter()->writeElement('image:loc',form_inputFilter::isURL($setConfig['image']['url'].$key));
                                    $this->xmlWriter()->endElement();
                                }
                            }else{
                                if($setConfig['image']['imageloc'] != NULL){
                                    $this->xmlWriter()->startElement('image:image');// [2] Second Node
                                    $this->xmlWriter()->writeElement('image:loc',form_inputFilter::isURL($setConfig['image']['url'].$setConfig['image']['imageloc']));
                                    $this->xmlWriter()->endElement();
                                }
                            }
                        }
                    }
                    $this->xmlWriter()->endElement();
                    break;
            }
        }

    }
    /**
     * Create GZ file from sitemap.xml
     * @param $file
     * @param $data
     * @return void
     */
    public function createGZ($file,$data){
        parent::makeGZFile($file,$data);
    }
    /**
     *
     * @param $url
     * @param $file
     * @return Send Sitemap Google webmaster
     */
    public function sendSitemapGoogle($url,$file){
        parent::googlePing($url,$file);
    }
}
?>