<?php
/*
 # -- BEGIN LICENSE BLOCK ----------------------------------
 #
 # This file is part of MAGIX CMS.
 # MAGIX CMS, The content management system optimized for users
 # Copyright (C) 2008 - 2013 magix-cms.com <support@magix-cms.com>
 #
 # OFFICIAL TEAM :
 #
 #   * Gerits Aurelien (Author - Developer) <aurelien@magix-cms.com> <contact@aurelien-gerits.be>
 #
 # Redistributions of files must retain the above copyright notice.
 # This program is free software: you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation, either version 3 of the License, or
 # (at your option) any later version.
 #
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.

 # You should have received a copy of the GNU General Public License
 # along with this program.  If not, see <http://www.gnu.org/licenses/>.
 #
 # -- END LICENSE BLOCK -----------------------------------

 # DISCLAIMER

 # Do not edit or add to this file if you wish to upgrade MAGIX CMS to newer
 # versions in the future. If you wish to customize MAGIX CMS for your
 # needs please refer to http://www.magix-cms.com for more information.
 */
/**
 * MAGIX CMS
 * @category   extends 
 * @package    Smarty
 * @subpackage function
 * @copyright  MAGIX CMS Copyright (c) 2010 Gerits Aurelien, 
 * http://www.magix-cms.com, http://www.magix-cjquery.com
 * @license    Dual licensed under the MIT or GPL Version 3 licenses.
 * @version    plugin version
 * @author Gérits Aurélien <aurelien@magix-cms.com> <aurelien@magix-dev.be>
 *
 */
/**
 * Smarty {headlink rel="" href="" optionnal(media="")} function plugin
 *
 * Type:     function
 * Name:     
 * Date:     
 * Purpose:  
 * Examples: {headlink}
 * Output:   
 * @link 
 * @author   Gerits Aurelien
 * @version  1.0
 * @param array
 * @param Smarty
 * @return string
 */
function smarty_function_headlink($params, $template){
	$rel = $params['rel'];
	if (!isset($rel)) {
	 	trigger_error("rel: missing 'rel' parameter in link");
		return;
	}
	$href = $params['href'];
	if (!isset($href)) {
	 	trigger_error("href: missing 'href' parameter in link");
		return;
	}
    $concat = $params['concat'];
    if($concat == '1'){
        $system = new component_core_system();
        if(defined('PATHADMIN')){
            $url = $system->getUrlConcat(array(
                'href'=>$href,
                'caches'=>'caching/caches',
                'filesgroups'=> 'min/groupsConfig.php',
                'minDir'=>'/'.PATHADMIN.'/min/',
                'callback'=>'/admin'
            ));
        }else{
            $url = $system->getUrlConcat(array(
                'href'=>$href,
                'caches'=>'var/caches',
                'filesgroups'=> 'min/groupsConfig.php',
                'minDir'=>'/min/',
                'callback'=>''
            ));
        }
    }elseif($concat == '0'){
        $url = $href;
    }else{
        $url = $href;
    }
	$ini = new helpers_headLink();
	switch($rel){
		case 'stylesheet':
			$head = $ini->linkStyleSheet($url,$params['media']);
		break;
		case 'rss':
			$head = $ini->linkRss($href);
		break;
	}
	return $head;
}